/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.data.filter;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.filter.CompanyFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.CountryFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.filter.GenerationFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.GenreFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.MediumFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.ParameterField;
import info.msxlaunchers.openmsx.launcher.data.filter.SizeFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.SoundFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.Value1Field;
import info.msxlaunchers.openmsx.launcher.data.filter.Value2Field;
import info.msxlaunchers.openmsx.launcher.data.filter.VideoSourceFilter;
import info.msxlaunchers.openmsx.launcher.data.filter.YearFilter;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.data.game.constants.VideoSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterFactory {
    private static final String MONIKER_SEPARATOR = ":";

    public static Filter createFilter(String type, String value1, String value2, String parameter) {
        FilterParameter effectiveParameter = null;
        if (parameter != null) {
            effectiveParameter = FilterParameter.valueOf(parameter);
        }
        return FilterFactory.createFilter(FilterType.valueOf(type), value1, value2, effectiveParameter);
    }

    public static Filter createFilter(FilterType type, String value1, String value2, FilterParameter parameter) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(value1);
        Filter filter = null;
        switch (type) {
            case COMPANY: {
                filter = new CompanyFilter(value1);
                break;
            }
            case COUNTRY: {
                filter = new CountryFilter(value1);
                break;
            }
            case GENERATION: {
                filter = new GenerationFilter(MSXGeneration.valueOf(value1));
                break;
            }
            case GENRE: {
                filter = new GenreFilter(Genre.valueOf(value1));
                break;
            }
            case MEDIUM: {
                filter = new MediumFilter(Medium.valueOf(value1));
                break;
            }
            case SIZE: {
                filter = new SizeFilter(Utils.getNumber(value1), Utils.getNumber(value2), parameter);
                break;
            }
            case SOUND: {
                filter = new SoundFilter(Sound.valueOf(value1));
                break;
            }
            case YEAR: {
                filter = new YearFilter(Utils.getNumber(value1), Utils.getNumber(value2), parameter);
                break;
            }
            case VIDEO_SOURCE: {
                filter = new VideoSourceFilter(VideoSource.valueOf(value1));
            }
        }
        return filter;
    }

    public static String getFilterMoniker(Filter filter) {
        Objects.requireNonNull(filter);
        StringBuilder builder = new StringBuilder();
        builder.append((Object)FilterFactory.getFilterType(filter)).append(MONIKER_SEPARATOR);
        builder.append(FilterFactory.getAnnotatedFieldValue(filter, Value1Field.class)).append(MONIKER_SEPARATOR);
        String value2 = FilterFactory.getAnnotatedFieldValue(filter, Value2Field.class);
        builder.append(value2 == null ? "" : value2).append(MONIKER_SEPARATOR);
        String parameter = FilterFactory.getAnnotatedFieldValue(filter, ParameterField.class);
        builder.append(parameter == null ? "" : parameter);
        return builder.toString();
    }

    public static List<String> getFilterMonikers(Set<Filter> filters) {
        if (filters == null) {
            return Collections.emptyList();
        }
        return filters.stream().map(FilterFactory::getFilterMoniker).collect(Collectors.toList());
    }

    public static FilterType getFilterType(Filter filter) {
        Objects.requireNonNull(filter);
        return filter.getClass().getAnnotation(FilterDescriptor.class).type();
    }

    public static String getAnnotatedFieldValue(Filter filter, Class<? extends Annotation> annotation) {
        Objects.requireNonNull(filter);
        Objects.requireNonNull(annotation);
        String value = null;
        Field[] fields = filter.getClass().getDeclaredFields();
        boolean done = false;
        for (int ix = 0; ix < fields.length && !done; ++ix) {
            Annotation annotatedField = fields[ix].getAnnotation(annotation);
            if (annotatedField == null) continue;
            try {
                fields[ix].setAccessible(true);
                value = fields[ix].get(filter).toString();
                done = true;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return value;
    }
}

